# Конфигурационный файл МДМ-сервера

- [Название  файла](#N)
- [Параметры и секции](#OP)
- [Подробный пример](#DE)

Далее указаны пример и параметры секций файла настроек.

## <a name="N"></a>Название файла

    mdm.yml

## <a name="OP"></a>Параметры и секции

Параметры:

- [mdm.mdm_cert](#MDMCRT)
- [mdm.mdm_key](#MDMKEY)
- [mdm.app_conf_cert](#APPCRT)
- [mdm.app_conf_key](#APPKEY)
- [mdm.log_format](#LOGFORMAT)
- [mdm.log](#LOG)
- [mdm.default_ownership](#OWN)
- [mdm.ios_wallpaper_cache_size](#WCZ)

Секции:

- [mdm.lost_mode_messages](#LMM)
- [mdm.db_pool](#DBP)

## <a name="DE"></a>Подробный пример
В данном примере представлен наиболее подробный конфигурационный файл с максимальным количеством настроек. В продакшене нужны не все настройки

    mdm:
      log: d # уровни логирования DEBUG (D, T), INFO (I), WARNING (W), ERROR (E), FATAL (F, CRITICAL, C) - регистр любой
      timing: c # только для разработчиков - логирование хронометража ХП

      # для подписи профиля Apple
      mdm_cert: \config\iosmdm.crt
      mdm_key: \config\iosmdm.key

      # настройки МСК (экран блокировки при потере устройства)
      lost_mode_messages:
        message: Устройство заблокировано
        footnote: Обратитесь к администратору

      # настройки MDM-сервера
      sowa: true                           # только для разработчиков - true|false включение проверки json body запроса
      server:
        numthreads: 19                     # количество потоков МДМ-сервера

      db_pool:
        minconn: 3
        maxconn: 40

## <a name="8.2"></a> Изменения 8.2
Начиная с версии 8.2 параметры MDM сервера, относящиеся к порталу регистрации и пуш серверу MDM были перенесены в 
отдельные конфигурационные файлы в связи с появлением отдельных сервисов.  
Далее представлен список перенесённых параметров.

Все параметры, отсутствующие в данном файле относительно версии 7.0 более не поддерживаются

Новые секции:
1. Секция `db_pool` - настройка подключений к БД

Подробности о параметрах по ссылкам  
**[regportal.yml](../regportal/regportal_config.md)**  
Конфигурационный файл портала регистрации
1. Секция `providers` - отвечает за способы регистрации
2. Секция `monitor` - отвечает за url мониторов, скачиваемых на странице регистрации
3. Секция `ldap` - отвечает за настройки блокировки попыток входа через ldap
4. Параметры `mdm_cert` и `mdm_key` продублированы в конфигах regportal.yml и mdm.yml


## <a name="9.0"></a> Изменения 9.0
1. Подсекция `cache` была полностью удалена, так как за раздачу файлов отвечает FDS
2. Подсекция `monitorpush` также удалена в связи с переписанным пуш сервером

## <a name="11.0"></a> Изменения 11.0
1. Наименование файла изменено с iosmdm.yml на mdm.yml
2. Добавлены параметры `app_conf_cert` и `app_conf_key`

## <a name="11.0"></a> Изменения 12.0
1. Добавлен параметр `ios_wallpaper_cache_size`


## <a name="LMM"></a>Подсекция `lost_mode_messages`
Отвечает за сообщения, показываемые на экране при блокировке устройства (режиме пропажи)  
Обязательная: нет

      lost_mode_messages:
        message: Устройство заблокировано
        footnote: Обратитесь к администратору

`message` - текст в верхней части экрана  
`footnote` - текст в нижней части экрана

## <a name="DBP"></a>Подсекция `db_pool`
Отвечает за настройки базы данных  
Обязательная: нет
  
    db_pool:
        minconn: 3
        maxconn: 40

`minconn` - минимальное количество соединений с БД. По умолчанию 5.  
`maxconn` - максимальное количество соединений с БД. По умолчанию 40.


## <a name="MDMCRT"></a>Параметр mdm.mdm_cert
Сертификат для подписи профиля iOS  
Значения: str  
Обазятельное: да  
По умолчанию: config/iosmdm.crt  

    mdm:
        ...
        mdm_cert: /config/iosmdm.crt

Параметр `mdm_cert` определяет пусть к сертификату мдм-сервера.  
Если параметр не указан, то мдм-сервер использует путь к сертификату iOS устройств (`config/iosmdm.crt`).  
Требуется только для управления iOS


## <a name="MDMKEY"></a>Параметр mdm.mdm_key
Ключ для подписи профиля iOS


    mdm:
        ...
        mdm_key: /config/iosmdm.key

Параметр `mdm_key` определяет пусть к приватному ключу сертификата мдм-сервера.

Если параметр не указан, то мдм-сервер использует путь к сертификату iOS устройств (`config/iosmdm.key`).

Ключ участвует в подписи профиля управления mdm.
Требуется только для управления iOS


## <a name="APPCRT"></a>Параметр mdm.app_conf_cert
Сертификат, содержащий открытый ключ RSA (pem)<br>
Значения: str<br>
Обязательное: нет<br>
По умолчанию: None

    mdm:
        ...
        app_conf_cert: /config/rsacert.pem

Параметр `app_conf_cert` определяет пусть к открытому сертификату MDM-сервера, участвующему в формировании JWT для подписании Конфигурации Приложения (КП).
Если параметр не указан, это требует в БД `configuration.cfg_has_signature == False`.
Используется только для формирования JWT для КП.


## <a name="APPKEY"></a>Параметр mdm.app_conf_key
Закрытый (приватный, секретный) ключ RSA (pem)<br>
Значения: str<br>
Обязательное: да, если присутствует параметр mdm.app_conf_cert<br>
По умолчанию: None

    mdm:
        ...
        app_conf_key: /config/rsaprivkey.pem

Параметр `app_conf_key` определяет пусть к закрытому ключу MDM-сервера, подписывающему JWT Конфигурации Приложения (КП).
Если параметр не указан, это требует в БД `configuration.cfg_has_signature == False`.
Используется только для подписания формирования JWT для КП.



## <a name="LOGFORMAT"></a>Параметр mdm.log_format
Формат логирования

Если параметр не указан используется формат по умолчанию


    mdm:
        ...
        log_format: %(levelname).1s:(%(threadName)-10s): %(filename)s: %(funcName)s: %(lineno)s: %(message)s
        ...

Параметр `log_format` определяет формат логирования

## <a name="LOG"></a>Параметр mdm.log
Уровень логирования  
Значения: DEBUG/D/T/INFO/I/WARNING/W/ERROR/E/FATAL/F/CRITICAL/C



    mdm:
        ...
        log: D
        ...


## <a name="WCZ"></a>Параметр mdm.ios_wallpaper_cache_size
Значения: int<br>
Обязательное: нет  
По умолчанию: 5

    mdm:
        ...
        ios_wallpaper_cache_size: 5
        ...
Количество файлов обоев iOS, кэширующихся на MDM сервере
