# Конфигурационный файл REGPORTAL

- [Название файла](#N)
- [Параметры и секции](#OP)
- [Подробный пример](#DE)

Далее указаны пример и параметры секций файла настроек.

## <a name="N"></a>Название файла

    regportal.yml


## <a name="8.2"></a>Изменения 8.2

Весь данный конфигурационный файл является новым, бОльшая часть параметров пришла сюда из iosmdm.yml

## <a name="11.0"></a>Изменения 11.0

Изменена секция monitor
Теперь это словарь следующего формата:
```yaml
  monitor:
    Android:
      regex: \bandroid
      url: https://safemobile.store/android/{version}/monitor.apk
    Aurora:
      regex: (^(?!.*\b(?:Windows|Mac|iPhone)\b).*\bGecko\/.*$)|(\bsailfish)
      url: https://safemobile.store/aurora/{version}/monitor.rpm
    iOS:
      regex: \biphone|\bmac
      url: https://apps.apple.com/ru/app/id1462613087
```

Ключ - название платформы монитора  
Значения: regex - регулярное выражение для определения платформы по User-Agent  
url - ссылка на монитор, версия подставляется динамически в зависимости от мажорной версии портала регистрации

## <a name="11.0"></a>Изменения 13.0
Удалён блок server в связи с переходом на асинхронный режим работы

## <a name="OP"></a>Параметры и секции

Параметры:

- [regportal.log](#LOG)
- [regportal.log_format](#LOGFORMAT)
- [regportal.mdm_cert](#MDMCRT)
- [regportal.mdm_key](#MDMKEY)

Секции:

- [regportal.providers](#PRVD)
- [regportal.ldap](#LDAP)
- [regportal.monitor](#MONITOR)

## <a name="DE"></a>Подробный пример
```yaml
regportal:
  log: D   # уровни логирования DEBUG (D, T), INFO (I), WARNING (W), ERROR (E), FATAL (F, CRITICAL, C) - регистр любой

  # для подписи профиля Apple
  mdm_cert: /config/iosmdm.crt
  mdm_key: /iosmdm.key

  providers: # способы регистрации
    - code
    - ldap

  ldap: # настройка сервера ldap
    account_lockout_threshold: 3              # количество попыток входа до блокировки
    reset_account_lockout_counter_after: 1    # таймаут до сброса количества попыток, минуты
    account_lockout_duration: 2               # длительность блокировки, минуты

  monitor:
    Android:
      regex: \bandroid
      url: https://safemobile.store/android/{version}/monitor.apk
    Aurora:
      regex: (^(?!.*\b(?:Windows|Mac|iPhone)\b).*\bGecko\/.*$)|(\bsailfish)
      url: https://safemobile.store/aurora/{version}/monitor.rpm
    iOS:
      regex: \biphone|\bmac
      url: https://apps.apple.com/ru/app/id1462613087
    
  jwt_expiration: 30
```

## <a name="LOG"></a>Параметр regportal.log
Уровень логирования  
Значения: DEBUG/D/T/INFO/I/WARNING/W/ERROR/E/FATAL/F/CRITICAL/C  

    regportal:
        ...
        log: D
        ...

Параметр `log_format` определяет формат логирования

## <a name="LOGFORMAT"></a>Параметр regportal.log_format
Формат логирования  
Если параметр не указан используется формат по умолчанию  

    regportal:
        ...
        log_format: %(levelname).1s:(%(threadName)-10s): %(filename)s: %(funcName)s: %(lineno)s: %(message)s
        ...

Параметр `log_format` определяет формат логирования

## <a name="MDMCRT"></a>Параметр regportal.mdm_cert
Сертификат для подписи профиля iOS  
Значения: str  
Обазятельное: да  
По умолчанию: config/iosmdm.crt  

    regportal:
        ...
        mdm_cert: ../config/iosmdm.crt

Параметр `mdm_cert` определяет пусть к сертификату мдм-сервера.  
Требуется только для подключения iOS

## <a name="MDMKEY"></a>Параметр regportal.mdm_key
Ключ для подписи профиля iOS  


    regportal:
        ...
        mdm_key: ../config/iosmdm.key

Параметр `mdm_key` определяет пусть к приватному ключу сертификата мдм-сервера.

Если параметр не указан, то мдм-сервер использует путь к сертификату iOS устройств (`config/iosmdm.key`).

Ключ участвует в подписи профиля управления mdm.
Требуется только для подключения iOS


## <a name="PRVD"></a>Подсекция `providers`
Отвечает за параметры авторизации  
Обязательная: да  

      providers:
        - code
        - ldap

`code` - авторизация по коду приглашения  
`ldap` - авторизация по учётным данным LDAP  

## <a name="LDAP"></a>Подсекция `ldap`
Отвечает за настройки авторизации по LDAP  
Обязательная: нет

      ldap:
        account_lockout_threshold: 3 
        reset_account_lockout_counter_after: 1 
        account_lockout_duration: 2

`account_lockout_threshold` - количество неудачных попыток входа до блокировки
`reset_account_lockout_counter_after` - таймаут до сброса счетчика неудачных попыток, минуты
`account_lockout_duration` - длительность блокировки, минуты

## <a name="MONITOR"></a>Подсекция `monitor`
Отвечает за ссылки на мониторы для разных ОС  
Обязательная: да  
Представляет собой массив словарей, каждый новый элемент начинается с -

```yaml
  monitor:
    Android:
      regex: \bandroid
      url: https://safemobile.store/android/{version}/monitor.apk
    Aurora:
      regex: (^(?!.*\b(?:Windows|Mac|iPhone)\b).*\bGecko\/.*$)|(\bsailfish)
      url: https://safemobile.store/aurora/{version}/monitor-aurora4.rpm
    Aurora5:
      regex: \bAurora 5\.\d+
      url: https://safemobile.store/aurora/{version}/monitor-aurora5.rpm
    iOS:
      regex: \biphone|\bmac
      url: https://apps.apple.com/ru/app/id1462613087
```

`regex` - регулярное выражение для определения типа ОС (используется для определения платформы по user-agent)
`url` - ссылка на монитор, версия подставляется динамически в зависимости от текущей версии портала регистрации, при необходимости можно подставить конкретную версию, заменив `{version}` на например 11.0

## <a name="JWT"></a>Параметр `jwt_expiration`
Время жизни jwt сессии в минутах
По умолчанию равно 30
