# Конфигурационный файл SafeMobile API (SMAPI)


## 1. Имя файла
Настройки SafeMobile API находятся в конфигурационном файле сервера `/config/smapi.yml`:

## 2. Образцы файла конфигурации

### Образец для продакшена

```yml
smapi:
  log: w      # уровни логирования DEBUG (D,T), INFO (I), WARNING (W), ERROR (E), FATAL (F, CRITICAL, C) - регистр любой
  #app_conf_cert: /config/app_cfg_rsacert.pem  # сертификат для проверки подписи JWT КП

  server:
    port: 8089

```

### Подробный
```yml
smapi:
  log: d      # уровни логирования DEBUG (D,T), INFO (I), WARNING (W), ERROR (E), FATAL (F, CRITICAL, C) - регистр любой
  log_format: "%(asctime)s %(levelname).1s: (%(threadName)-10s): %(filename)s/%(funcName)s(%(lineno)s): %(message)s"

  app_conf_cert: D:\projects\combat\smapi\config\rsacert.pem  # сертификат для проверки подписи JWT КП

# --------------------------------------------------------------
# ниже настройки для разработчиков и тестировщиков, 
# не трогайте их, если не уверены в своих действиях
# --------------------------------------------------------------

  timing: c                   # при достижении параметром log этого уровня, становится виден хронометрах запросов
  max_records: 100000         # максимальная длина любого списка response в штуках записей
  reload_settings_period: 0   # период перечитывания настроек в секундах, 0 - не перечитывать

  server:                     # параметры WSGI
    host: 0.0.0.0
    port: 8085
    probe_port: 9000                 # порт (умолчание 9000) на выделенный сервер для пробы жизнеспособности
    dedicated_probe_server: DISABLE  # enable/disable - регистр любой, по умолчанию выделенный сервер стартует
    numthreads: 40                   # количество потоков SMAPI-сервера

#  otlp_endpoint: http://10.200.214.52:4317  # если указан, то сборщику будут посылаться логи в формате JSON по OTLP

  db_pool:                    # пул коннектов к базе
    minconn: 3
    maxconn: 40
#    pgtz: UTC+3               # time zone для psycopg2, по умолчанию UTC
```

## 3. Описание

### Секция smapi
* **smapi/log**
  * Строка, обозначающая уровень логирования.
  * Может принимать значения DEBUG (D,T), INFO (I), WARNING (W), ERROR (E), FATAL (F, CRITICAL, C) - регистр любой.
  * По умолчанию `W`
* **smapi/app_conf_cert**
  * Строка, содержащая путь к файлу сертификата.
  * Конфигурация приложения содержится внутри JWT-токена, который подписывается закрытым ключом. 
  * Сертификат используется для проверки подписи, удостоверяющей конфигурацию приложения и факт нахождения устройства под управлением.
* **smapi/log_format**
  * Строка, содержащая Формат вывода строки логирования. Внутренний параметр сервера.
  * Значение по умолчанию<br>
   `"%(asctime)s %(levelname).1s: (%(threadName)-10s): %(filename)s/%(funcName)s(%(lineno)s): %(message)s"`
* **smapi/timing**
  * Строка, обозначающая, надо ли логировать хронометраж запросов.
  * Если уровень логирования хронометража достигает уровня логирования сервера (см. выше `smapi/log`), то сервер логирует время выполнения запроса.
  * По умолчанию `c` - хронометраж отключен.
* **smapi/max_records**
  * Целое число, параметр пагинации, обозначающее длину получаемого клиентом списка, выраженную в количестве записей.
  * По умолчанию `100000`, увеличение может привести к задержкам обработки.
* **smapi/otlp_endpoint**
  * во время старта сервер ищет в конфиге параметр `otlp_endpoint`
  * если не находит, ищет переменную окружения `OTEL_EXPORTER_OTLP_ENDPOINT`
  * и пытается извлечь из них адрес для логирования по OTLP
  * если адрес не найден, логирование по OTLP не включается, иначе логи в формате JSON отсылаются коллектору
  * логирование в консоль происходит всегда
* **smapi/reload_settings_period**
  * Целое, обозначающее интервал обновления настроек сервера. 
  * Планируется, пока не реализовано.
 
### Секция server
  * **smapi/server/host**
    * Строка, обозначающая хост прослушивания.
    * Внутренний параметр сервера flask, значение по умолчанию '`0.0.0.0`' делегирует назначение хоста серверу WSGI. 
  * **smapi/server/port**
    * Целое, обозначающее порт прослушивания.
    * ВНИМАНИЕ. По умолчанию 8085, но требует установки в `8089` (настройки nginx).
  * **smapi/server/numthreads**
    * Целое число, обозначающее количество потоков Сервера.
    * Сервер работает в многопоточном режиме, масштабируясь под количество запросов. Лишние потоки закрываются автоматически.
    * Значение по умолчанию `40`, должно соответствовать количеству коннектов к БД.
  * **smapi/server/probe_port**
    * Целое, обозначающее порт прослушивания запроса пробы жизнеспособности <host>/health/liveness
    * По умолчанию `9000`
  * **smapi/server/dedicated_probe_server**
    * Строка, обозначающая необходимость старта в отдельном потоке выделенного сервера для прослушивания пробы жизнеспособности <host>/health/liveness
    * Может принимать значения enable/disable (регистр любой), по умолчанию используется `enable` 
    * Если установлено `disable`, то параметр `smapi/server/probe_port` должен быть удалён (закомментирован)

### Секция db/pool
  * **smapi/db_pool/minconn, smapi/db_pool/maxconn**
    * Целое, обозначающее минимальное и максимальное число коннектов к БД.
    * По умолчанию `5` и `40` соответственно.
    * Уменьшение числа коннектов приводит к замедлению обработки запросов, увеличение вызывает увеличение числа процессов на сервере БД. Интервал должен соответствовать производительности Сервера SMAPI.
  * **smapi/db_pool/pgtz**
    * Строка, обозначающая временную зону драйвера БД.
    * По умолчанию `UTC`
    * Использование этого параметра должно происходить в строгом соответствии с документацией PostgreSQL.<br>Изменять не рекомендуется.
