# Сервис SafeMobile API (smapi)

Сервис SMAPI является web-сервером, реализующим REST-подобное API.

### 1. Примеры обращения к сервису

**Пример №1**. Формирование полного роута api.

    Конкатенация:
    - https://host:port
    - /api
    - /v1
    - /роут_api
    Например `https://sso2.local:8085/api/v1/devices`

**Пример №2**. Запрос кода приглашения `(cUrl)`

```http request
POST /api/v1/accesscode/createfordn HTTP/1.1
Host: 127.0.0.1:8085
X-Domain-Api-Token: bf4ab5d697462d36eb6d658dc815ff3f27d6465211b89250d9663c5f852f406f
Content-Type: application/json
{
  "distinguished_name": "CN=Евдокимова Мария Максимовна,OU=OrgUnit-5-03,OU=OrgUnit-4-03,OU=OrgUnit-3-03,OU=OrgUnit-2-03,OU=OrgUnitStart,DC=safemobile,DC=pro",
  "valid_till": "2023-06-30T13:15:18.063Z"
}
```

```curl
curl --location 'http://127.0.0.1:8085/api/v1/accesscode/createfordn' \
--header 'X-Domain-Api-Token: bf4ab5d697462d36eb6d658dc815ff3f27d6465211b89250d9663c5f852f406f' \
--header 'Content-Type: application/json' \
--data '{
  "distinguished_name": "CN=Евдокимова Мария Максимовна,OU=OrgUnit-5-03,OU=OrgUnit-4-03,OU=OrgUnit-3-03,OU=OrgUnit-2-03,OU=OrgUnitStart,DC=safemobile,DC=pro",
  "valid_till": "2023-06-30T13:15:18.063Z"
}'
```

Ответ

```json
  {
    "code": 123456789
  }
```

**Пример №3**. Получение ID сотрудника в системе SafeMobile `(Python)`

    Этот ID является входным параметром во всех остальных запросах.

```http request
POST /api/v1/employee HTTP/1.1
Host: 127.0.0.1:8085
X-Domain-Api-Token: bf4ab5d697462d36eb6d658dc815ff3f27d6465211b89250d9663c5f852f406f
Content-Type: application/json
{
  "distinguished_name": "CN=Кузнецов Тимур Кириллович,OU=OrgUnit-5-03,OU=OrgUnit-4-03,OU=OrgUnit-3-03,OU=OrgUnit-2-03,OU=OrgUnitStart,DC=safemobile,DC=pro"
}
```

```python
import requests
import json

url = "http://127.0.0.1:8085/api/v1/employee"
payload = json.dumps({
  "distinguished_name": "CN=Кузнецов Тимур Кириллович,OU=OrgUnit-5-03,OU=OrgUnit-4-03,OU=OrgUnit-3-03,OU=OrgUnit-2-03,OU=OrgUnitStart,DC=safemobile,DC=pro"
})
headers = {
  'X-Domain-Api-Token': 'bf4ab5d697462d36eb6d658dc815ff3f27d6465211b89250d9663c5f852f406f',
  'Content-Type': 'application/json'
}
response = requests.request("POST", url, headers=headers, data=payload)
print(response.text)
```

Ответ

```json
  {
    "sm_employee_id": 12345
  }
```