## Глоссарий параметров OpenAPI
> Это входные параметры, которые содержатся в теле (body) [запроса к SMAPI](swagger.yaml),  
> за исключением `X-Domain-Api-Token`, который является заголовком и содержит токен авторизации.  
> Время и дата указываются в формате Зулу "гггг-мм-ддTчч:мм:сс.мммZ"".

### Г
- `Группа`  
  1. группа (безопасности) из Active Directory, определяется DN  
  2. правило импорта группы (АРМ - Синхронизация данных AD - Группы)  
  3. результат импорта (АРМ - Объекты учёта - Группы)
### К
- `комплект` - MCC, телефон, планшет, браслет и т.д., находящийся под управлением SM
### О
- `ОШС` - организационно-штатная структура
### П
- `ПУП` - правило управления приложением
### A
- `ad_employee_id` - синоним employee_id для методов: /api/v1/employee и /api/v1/employee/list
- `AD` - Microsoft Active Directory
- `ae_assignment_type` - режим назначения профиля (1 - ручной, 2 - автоматический. используется в правилах несоответствия)
- `appd_id` - идентификатор дистрибутива приложения
- `appr_backup_denied` - резервная копия приложения запрещена (только для iOS)
- `appr_delay` - время, на которое сотрудник может отложить обновление корпоративного приложения, минуты (только для Android)
- `appr_delete_on_cutoff` - удалить с устройства при отключении от управления
- `appr_description` - словесное описание ПУП
- `appr_is_enabled` - приложение должно быть включено (только для Android)
- `appr_is_installed` - флаг установки приложения (`1` - приложение должно быть установлено, `0` - приложение должно быть удалено, `NULL` - не задано, `2` - доступно в SafeStore)
- `appr_install_to_container` - флаг работы с контейнером (установка/удаление приложения)
- `appr_id` - Идентификатор ПУП-а
- `appr_prevent_closing` - ОС запрещено автоматически закрывать приложение (только для Android)
- `appr_silent` - приложение устанавливается и обновляется в "тихом" режиме, без вывода уведомлений пользователю (только для Android)
- `appr_title` - заголовок (название ПУП)
- `appr_vpnuuid` - использовать VPN для приложений (Per-App VPN), только для iOS
- `appr_weight` - вес (результирующее правило с большим весом выполняется в первую очередь)
- `app_uid` - UID приложения
- `ar_is_needed` - флаг установки приложения (True - установить, False - удалить)
### C
- `cleaning_date` - дата очистки, фильтр для удаления комплектов: удаляться должны устройства, отключенные ранее этой даты
- `conditions` - словарь условий применения профилей и ПУП
- `continuation_token` - токен пагинации, содержит ссылку на следующий блок информации (блок может оказаться пустым)
### D
- `distinguished_name` - идентификатор сотрудника в AD
- `DN` - см. `distinguished_name`
### E
- `employee_id` - идентификатор сотрудника в AD
- `end_date_enroll` - время окончания поиска регистрации комплекта (в формате Зулу)
- `end_date` - конечное время для фильтрации записей (в формате Зулу)
### I
- `is_assignment` - флаг назначения (True) / снятия (False) ПУП-а
- `is_primary_owner` - логический признак основного сотрудника комплекта (технический владелец), используется при получении кода приглашения
### L
- `LDAP` - аналог Active Directory в Linux (Lightweight Directory Access Protocol - легковесный протокол доступа к каталогам)
- `ldaps_autosync_enabled` - флаг автосинхронизации (True - включить, False - выключить)
- `ldaps_id` - идентификатор внешнего каталога
- `ldapir_base_dn` - DN базового каталога для группы
- `ldapir_group_dn` - DN группы в LDAP
- `ldapir_id` - идентификатор правила синхронизации группы LDAP
- `limit` - параметр пагинации, число записей в ответе на запрос
### M
- `mcc_id` - kit_id, идентификатор комплекта сотрудника в SM
- `mob_st_uncontrol` - статус управления устройства (`control` - под управлением, `req_uncontrol` - запрошено отключение от управления, `uncontrol` - отключено от управления)
- `mob_st_connect` - статус подключения устройства (`connected` - в сети, последняя активность была менее 15 минут назад, `disconnected` - не в сети, последняя активность была в промежутке от 15 минут до 24 часов, `long_been_disconnected` - долго не в сети, последняя активность была более 24 часов назад)
### N
- `notification` - сообщение от администратора, доставляется на устройство по `mcc_id`, см. так же `title` 
### O
- `ost_id` - идентификатор платформы (`1` - `iPhone OS`, `2` - `Android`, `4` - `Windows`, `6` - `SafeLife`, `7` - `AuroraOS`, `8` - `Linux`)
- `ot_id` - идентификатор подразделения ОШС
### P
- `password` - новый пароль комплекта сотрудника
- `pol_pt_id` - тип профиля, числовая константа
- `policies` - словарь конкретных политик профиля
- `prof_description` - словесное описание профиля
- `prof_title` - заголовок (название) профиля
- `prof_id` - идентификатор профиля, применимо для `/profile/create`, `/profile/modify`, `/profile/list`
- `profile_id` - идентификатор профиля для остальных api (кроме профилей)
- `profile` - словарь специфических полей профиля
### S
- `sam_account_name` - идентификатор сотрудника sAMAccountname в AD
- `SM` - Safe Mobile НИИ СОКБ
- `sm_employee_id` - emp_id, идентификатор сотрудника в SM
- `start_date` - начальное время для фильтрации записей (в формате Зулу)
- `start_date_enroll` - начальное время для поиска регистраций комплектов (в формате Зулу)
### T
- `title` - заголовок сообщения, см. так же `notification`
- `totp` - одноразовый код с привязкой по времени, соообщается Монитором Android
### V
- `valid_till` - время, до которого действует код приглашения
### X
- `X-Domain-Api-Token` - заголовок запроса, содержит токен авторизации